#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_Supply : BaseTest 
	{
		
		private DataTable _dtSupply;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtSupply = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Supply WHERE SatisfactoryIndicator = 1	AND	AvailableQuantity > 0 AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetSupplies_Pass()
		{
			int supplyTypeId = System.Convert.ToInt32(this._dtSupply.Rows[0][TABLES.Supply.SupplyTypeId]);
			Common.SupplyType supplyType = (Common.SupplyType)supplyTypeId;

			string manufacturerName = this._dtSupply.Rows[0][TABLES.Supply.ManufacturerName].ToString();
			string lotNumber = this._dtSupply.Rows[0][TABLES.Supply.LotNumber].ToString();

			DataTable dtTest = DAL.Supply.GetSupplies(supplyType, manufacturerName, lotNumber, false);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count - Specific");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyGuid), TABLES.Supply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotQuantity), TABLES.Supply.LotQuantity);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.DivisionCode), TABLES.Supply.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.RowVersion), TABLES.Supply.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InventoryChangeDate), TABLES.Supply.InventoryChangeDate);


			DataTable dtTest2 = DAL.Supply.GetSupplies(Common.SupplyType.AllSupplies, null, null,false);
			Assert.AreEqual(true, dtTest2.Rows.Count > 0, "Rows.Count - AllSupplies");

			DataTable dtTest3 = DAL.Supply.GetSupplies(supplyType, null, null,false);
			Assert.AreEqual(true, dtTest3.Rows.Count > 0, "Rows.Count - SupplyType filter");
		}

		[Test]
		public void GetSupplies_Fail()
		{
			DataTable dtTest = DAL.Supply.GetSupplies(Common.SupplyType.Unknown, "@123@", "@123@", false);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSupplyByInvoiceLotNumber_Pass()
		{
			int supplyTypeId = System.Convert.ToInt32(this._dtSupply.Rows[0][TABLES.Supply.SupplyTypeId]);
			string invoiceNumber = this._dtSupply.Rows[0][TABLES.Supply.InvoiceNumber].ToString();
			string lotNumber = this._dtSupply.Rows[0][TABLES.Supply.LotNumber].ToString();

			DataTable dtTest = DAL.Supply.GetSupplyByInvoiceLotNumber(invoiceNumber, lotNumber, supplyTypeId);

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyGuid), TABLES.Supply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotQuantity), TABLES.Supply.LotQuantity);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.DivisionCode), TABLES.Supply.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.RowVersion), TABLES.Supply.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InventoryChangeDate), TABLES.Supply.InventoryChangeDate);
		}

		[Test]
		public void GetSupplyByInvoiceLotNumber_Fail()
		{
			DataTable dtTest = DAL.Supply.GetSupplyByInvoiceLotNumber("@123@","@123",0);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSupplyByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid];

			DataTable dtTest = DAL.Supply.GetSupplyByGuid(unitGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyGuid), TABLES.Supply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotQuantity), TABLES.Supply.LotQuantity);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.DivisionCode), TABLES.Supply.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.RowVersion), TABLES.Supply.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InventoryChangeDate), TABLES.Supply.InventoryChangeDate);
		}

		[Test]
		public void GetSupplyByGuid_Fail()
		{
			DataTable dtTest = DAL.Supply.GetSupplyByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEmptySupplyTable_Pass()
		{
			DataTable dtTest = DAL.Supply.GetEmptySupplyTable();

			Assert.AreEqual(TABLES.Supply.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(20, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.DivisionCode), TABLES.Supply.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyGuid), TABLES.Supply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LastUpdateDate), TABLES.Supply.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LastUpdateUser), TABLES.Supply.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LastUpdateFunctionId), TABLES.Supply.LastUpdateFunctionId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.RowVersion), TABLES.Supply.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotQuantity), TABLES.Supply.LotQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InventoryChangeDate), TABLES.Supply.InventoryChangeDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptySupplyTable_Fail()
		{
		}

		[Test]
		public void GetInsertSupplyDataTable_Pass()
		{
			DataTable dtTest = DAL.Supply.GetInsertSupplyDataTable();

			Assert.AreEqual(TABLES.Supply.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(16, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyGuid), TABLES.Supply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotQuantity), TABLES.Supply.LotQuantity);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.DivisionCode), TABLES.Supply.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LastUpdateUser), TABLES.Supply.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LastUpdateFunctionId), TABLES.Supply.LastUpdateFunctionId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetInsertSupplyDataTable_Fail()
		{
		}

		[Test]
		public void GetManufacturerNameList_Pass()
		{
			DataTable dtTest = DAL.Supply.GetManufacturerNameList();
			
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetManufacturerNameList_Fail()
		{
		}

		[Test]
		public void GetSupplyNameList_Pass()
		{
			DataTable dtTest = DAL.Supply.GetSupplyNameList(this._dtSupply.Rows[0][TABLES.Supply.ManufacturerName].ToString());
		
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSupplyNameList_Fail()
		{
		}

		[Test]
		public void GetSupplyTypeList_Pass()
		{
			DataTable dtTest = DAL.Supply.GetSupplyTypeList();

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeId), TABLES.SupplyType.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSupplyTypeList_Fail()
		{
		}

		[Test]
		public void InsertSupplies_Pass()
		{
			DataTable dtISupply = SprocHelper.GetInsertSupplySprocTable(System.Guid.NewGuid());
			
			System.Guid [] supplyGuids = new System.Guid[1];
			if(dtISupply.Rows.Count > 0)
			{
				supplyGuids[0] = (System.Guid) dtISupply.Rows[0][TABLES.Supply.SupplyGuid];
			}
			else
			{
				supplyGuids[0] = System.Guid.NewGuid();
			}

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginSupply);
			DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginSupply, supplyGuids, Common.WorkloadTransactionType.Miscellanious, false);

			dtWorkloadEvent = Common.Utility.AppendLastUpdateInformation(dtWorkloadEvent, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.Supply.InsertSupplies(dtISupply, dtWorkloadEvent);

			//Cleanup our supply cuz it's crappy 
			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("DELETE FROM Supply WHERE SupplyGUid = '" + dtISupply.Rows[0][TABLES.Supply.SupplyGuid].ToString() + "'");
			}

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void InsertSupplies_Fail()
		{
			DataTable dtISupply = SprocHelper.GetInsertSupplySprocTable(System.Guid.NewGuid());
			//This will cause the crash
			dtISupply.Rows[0][TABLES.Supply.SupplyGuid] = this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid];
			System.Guid [] supplyGuids = new System.Guid[1];
			supplyGuids[0] = (System.Guid) dtISupply.Rows[0][TABLES.Supply.SupplyGuid];

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginSupply);
			DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginSupply, supplyGuids, Common.WorkloadTransactionType.Miscellanious, false);
			DAL.Supply.InsertSupplies(dtISupply, dtWorkloadEvent);
		}

		[Test]
		public void UpdateSupplyUsage_Pass()
		{
			this.RefreshData = true;

			DataTable dtSupply = new DataTable(TABLES.Supply.TableName);

			dtSupply.Columns.Add(TABLES.Supply.AvailableQuantity, typeof(int));
			dtSupply.Columns.Add(TABLES.Supply.Comments, typeof(string));
			dtSupply.Columns.Add(TABLES.Supply.DivisionCode, typeof(string));
			dtSupply.Columns.Add(TABLES.Supply.InventoryChangeDate, typeof(System.DateTime));
			dtSupply.Columns.Add(TABLES.Supply.RowVersion, typeof(byte[]));
			dtSupply.Columns.Add(TABLES.Supply.SupplyGuid, typeof(System.Guid));

			//Create our DataRow of update values
			DataRow drUpdateSupply = dtSupply.NewRow();

			drUpdateSupply[TABLES.Supply.AvailableQuantity] = new Random().Next(1,99);
			drUpdateSupply[TABLES.Supply.Comments] = System.DateTime.Now.ToString();
			drUpdateSupply[TABLES.Supply.DivisionCode] = this.TestDivisionCode;
			drUpdateSupply[TABLES.Supply.InventoryChangeDate] = System.DateTime.Now;
			drUpdateSupply[TABLES.Supply.RowVersion] = (byte[])this._dtSupply.Rows[0][TABLES.Supply.RowVersion];
			drUpdateSupply[TABLES.Supply.SupplyGuid] = (System.Guid)this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid];

			dtSupply.Rows.Add(drUpdateSupply);

			//Get the Workload
			System.Guid[] workloadGuids = {(System.Guid)this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid]};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateSupplyInventory);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateSupplyInventory, workloadGuids, Common.WorkloadTransactionType.Miscellanious, false);

			bool retValue = DAL.Supply.UpdateSupplyUsage(dtSupply, dtWorkload, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateSupplyUsage_Fail()
		{
			this.RefreshData = true;

			DataTable dtSupply = new DataTable(TABLES.Supply.TableName);

			dtSupply.Columns.Add(TABLES.Supply.AvailableQuantity, typeof(int));
			dtSupply.Columns.Add(TABLES.Supply.Comments, typeof(string));
			dtSupply.Columns.Add(TABLES.Supply.DivisionCode, typeof(string));
			dtSupply.Columns.Add(TABLES.Supply.InventoryChangeDate, typeof(System.DateTime));
			dtSupply.Columns.Add(TABLES.Supply.RowVersion, typeof(byte[]));
			dtSupply.Columns.Add(TABLES.Supply.SupplyGuid, typeof(System.Guid));

			//Create our DataRow of update values
			DataRow drUpdateSupply = dtSupply.NewRow();

			drUpdateSupply[TABLES.Supply.AvailableQuantity] = new Random().Next(1,99);
			drUpdateSupply[TABLES.Supply.Comments] = System.DateTime.Now.ToString();
			drUpdateSupply[TABLES.Supply.DivisionCode] = this.TestDivisionCode;
			drUpdateSupply[TABLES.Supply.InventoryChangeDate] = System.DateTime.Now;
			drUpdateSupply[TABLES.Supply.RowVersion] = new byte[8];
			drUpdateSupply[TABLES.Supply.SupplyGuid] = (System.Guid)this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid];

			dtSupply.Rows.Add(drUpdateSupply);

			//Get the Workload
			System.Guid[] workloadGuids = {(System.Guid)this._dtSupply.Rows[0][TABLES.Supply.SupplyGuid]};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateSupplyInventory);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateSupplyInventory, workloadGuids, Common.WorkloadTransactionType.Miscellanious, false);

			DAL.Supply.UpdateSupplyUsage(dtSupply, dtWorkload, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetSupplyInventoryReportData_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(10);

			DataTable dtTest = DAL.Supply.GetSupplyInventoryReportData(startDate, endDate, startDate, endDate, false, "1,2,3,4,5,6,7");

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyTypeId), TABLES.Supply.SupplyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SupplyType.SupplyTypeText), TABLES.SupplyType.SupplyTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ManufacturerName), TABLES.Supply.ManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SupplyName), TABLES.Supply.SupplyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotNumber), TABLES.Supply.LotNumber);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.LotExpirationDate), TABLES.Supply.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.AvailableQuantity), TABLES.Supply.AvailableQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.SatisfactoryIndicator), TABLES.Supply.SatisfactoryIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InvoiceNumber), TABLES.Supply.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptDate), TABLES.Supply.ReceiptDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.ReceiptTechId), TABLES.Supply.ReceiptTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.Comments), TABLES.Supply.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Supply.InventoryChangeDate), TABLES.Supply.InventoryChangeDate);
		}

		[Test]
		public void GetSupplyInventoryReportData_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(2);
			System.DateTime endDate = System.DateTime.MaxValue;

			DataTable dtTest = DAL.Supply.GetSupplyInventoryReportData(startDate, endDate, startDate, endDate, false, string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}

#endif



